%define module_name Math-Aronson
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(Iterator.pm) perl(Iterator/Simple.pm) perl(Lingua/Any/Numbers.pm) perl(Lingua/EN/Numbers.pm) perl(Lingua/ES/Numeros.pm) perl(Lingua/FR/Numbers.pm) perl(Math/NumSeq.pm) perl(Math/NumSeq/OEIS/Catalogue/Plugin.pm) perl(Module/Util.pm) perl(Smart/Comments.pm) perl(Test.pm) perl(Unicode/CharName.pm) perl(Unicode/Normalize.pm) perl(threads.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 10
Release: alt1
Summary: Generate Aronson's sequence.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/math-aronson/index.html

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRYDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a bit of fun generating Aronson's sequence of numbers formed by
self-referential occurrences of the letter T in numbers written out in
words.

    T is the first, fourth, eleventh, sixteenth, ...
    ^    ^       ^      ^         ^      ^   ^
    1    4      11     16        24     29  33  <-- sequence

In the initial string "T is the", the letter T is the first and fourth
letters, so those words are appended to make "T is the first, fourth".
Those words have further Ts at 11 and 16, so those numbers are appended, and
so on.

Spaces and punctuation are ignored.  Accents like acutes are stripped for
letter matching.  The `without_conjunctions' option can ignore "and" or
"et" too.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes COPYING examples
%perl_vendor_privlib/M*

%changelog
