%define module_name Math-Bacovia
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Multimethods.pm) perl(List/UtilsBy.pm) perl(Math/AnyNum.pm) perl(Module/Build.pm) perl(Set/Product/XS.pm) perl(Test/More.pm) perl(overload.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Symbolic math library with support for alternative representations.
Group: Development/Perl
License: artistic_2
URL: https://github.com/trizen/Math-Bacovia

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TR/TRIZEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Math::Bacovia is an experimental symbolic math library, with support for alternative representations, simplification of expressions and numerical evaluation.

    use 5.014;
    use Math::Bacovia qw(:all);

    my $x = Symbol('x');
    my $y = Symbol('y');

    say $x+$y;               #=> Sum(Symbol("x"), Symbol("y"))
    say $x-$y;               #=> Difference(Symbol("x"), Symbol("y"))
    say $x*$y;               #=> Product(Symbol("x"), Symbol("y"))
    say $x/$y;               #=> Fraction(Symbol("x"), Symbol("y"))

    say $x**$y;              #=> Power(Symbol("x"), Symbol("y"))

    say Log($x);             #=> Log(Symbol("x"))
    say Log($x)+Log($y);     #=> Log(Product(Symbol("x"), Symbol("y")))

    say Exp($x);             #=> Exp(Symbol("x"))
    say Exp($x)*Exp($y);     #=> Exp(Sum(Symbol("x"), Symbol("y")))

    say "\n=> Sum:";
    my $sum = Fraction(0, 1);

    for my $n (1..10) {
        $sum += Fraction(1, $n);
    }
    say $sum;                     #=> Fraction(10628640, 3628800)
    say $sum->numeric;            #=> 7381/2520

    say "\n=> Product:";
    my $prod = Product();

    for my $n (1..3) {
        $prod *= Exp(Fraction(1, $n));
    }

    say $prod->pretty;            #=> (exp(1) * exp(1/2) * exp(1/3))
    say $prod->simple->pretty;    #=> exp(11/6)
    say $prod->numeric;           #=> 6.25470095193632871640207...

    say "\n=> Alternative representations:";
    say join ', ', Power(3, 5)->alternatives(full => 1);   #=> Power(3, 5), Exp(Product(Log(3), 5)), 243

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes examples
%perl_vendor_privlib/M*

%changelog
