Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Math-ConvexHull
Version:        1.04
Release:        alt2_34
Summary:        Calculate convex hulls using Graham's scan (n*log(n))
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Math-ConvexHull
Source0:        https://cpan.metacpan.org/authors/id/S/SM/SMUELLER/Math-ConvexHull-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  dos2unix
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Runtime
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Tests
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(List/Util.pm)
BuildRequires:  perl(Test/More.pm)
Source44: import.info

%description
Math::ConvexHull is a simple module that calculates convex hulls from a set
of points in 2D space. It is a straightforward implementation of the
algorithm known as Graham's scan which, with complexity of O(n*log(n)), is
the fastest known method of finding the convex hull of an arbitrary set of
points. There are some methods of eliminating points that cannot be part of
the convex hull. These may or may not be implemented in a future version.

%prep
%setup -q -n Math-ConvexHull-%{version}
dos2unix Changes

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
