# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.022
%define module_name Math-DWT
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.022
Release: alt1
Summary: Pure Perl 1-D Discrete Wavelet Transform.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KROH/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module computes the forward and inverse Discrete Wavelet Transform using arbitrary wavelets defined in modules (many are included in the distribution).

    use Math::DWT;

    my $dwt = Math::DWT->new('Daubechies',1); # Haar

    my @x = qw/8 6 7 5 3 0 9 0/; # zero-pad input to make it 2^n long

    # perform a single transform with default loaded filters
    my $coeffs = $dwt->dwt(\@x);

    # $coeffs points to LEVEL+1 array refs

    # Check perfect reconstruction:
    my @X = $dwt->idwt($coeffs);

    my $maxerr=0;
    for(my $i=0;$i<scalar(@X);$i++) {
       my $err=abs($x[$i] - $X[$i]);
       $maxerr = $err if ($err > $maxerr);
    }

    print $maxerr . "\n"; # 5.27844434827784e-12 (close enough to 0)
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
