%define module_name Math-DifferenceSet-Planar
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Share.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(Math/Prime/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.002
Release: alt1
Summary: object class for planar difference sets
Group: Development/Perl
License: artistic_2
URL: https://vera.in-ulm.de/planar-diffsets/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MH/MHASCH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A planar difference set in a modular integer ring E<8484>_n, or cyclic
planar difference set, is a subset D = {d_1, d_2, ..., d_k} of E<8484>_n
such that each nonzero element of E<8484>_n can be represented as a
difference (d_i - d_j) in exactly one way.  By convention, only sets
with at least three elements are considered.

Necessarily, for such a set to exist, the modulus n has to be equal to
(k_-_1)_E<183>_k_+_1.  If (k_-_1) is a prime power, planar difference
sets can be constructed from a finite field of order (k_-_1).  It is
conjectured that no other planar difference sets exist.  If other families
of planar difference sets should be discovered, this library would be
due to be extended accordingly.

If D_=_{d_1,_d_2,_...,_d_k}_E<8834>_E<8484>_n is a difference set and
a is an element of E<8484>_n, D_+_a_=_{d_1_+_a,_d_2_+_a,_...,_d_k_+_a}
is also a difference set.  D_+_a is called a translate of D.  The set
of all translates of a planar difference set as lines and the elements
of E<8484>_n as points make up a finite projective plane (hence the name).

If t is an element of E<8484>_n coprime to n, D_E<183>_t =
{d_1_E<183>_t,_d_2_E<183>_t,_...,_d_k_E<183>_t} is also a difference
set.  If D_E<183>_t is a translate of D, t is called a multiplicator
of D.  If t is coprime to n but either identical to 1 (mod n) or not a
multiplicator, it is called a rotator.  Rotators of planar difference
sets are also rotators of planes as translates of a difference set
are mapped to translates of the rotated set.  We call a minimal set of
rotators spanning all plane rotations a rotator base.

Math::DifferenceSet::Planar provides examples of small cyclic planar
difference sets constructed from finite fields.  It is primarily intended
as a helper module for algorithms employing such sets.  It also allows
to iterate over all sets of a given size via translations and rotations,
and to verify whether an arbitrary set of modular integers is a cyclic
planar difference set.

Currently, only sets with k E<8804> 4097, or moduli E<...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes CONTRIBUTING README examples
%perl_vendor_privlib/M*
%perl_vendor_privlib/auto/*

%changelog
