%filter_from_requires /^perl.arybase.pm./d
%filter_from_requires /^perl.Evol.pm./d
%define module_name Math-Evol
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(complete.pl) perl(open.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.13
Release: alt2
Summary: Evolution search optimisation
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PJ/PJB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module implements the evolution search strategy.  Derivatives of
the objective function are not required.  Constraints can be incorporated.
The caller must supply initial values for the variables and for the
initial step sizes.

This evolution strategy is a random strategy, and as such is
particularly robust and will cope well with large numbers of variables,
or rugged objective funtions.

Evol.pm works either automatically (evol) with an objective function to
be minimised, or interactively (select_evol) with a (suitably patient)
human who at each step will choose the better of two possibilities.
Another subroutine (text_evol) allows the evolution of numeric parameters
in a text file, the parameters to be varied being identified in the text
by means of special comments.  A script *ps_evol* which uses that is
included for human-judgement-based fine-tuning of drawings in PostScript.

Version 1.12

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
