%define module_name Math-MPC
# BEGIN SourceDeps(oneline):
BuildRequires: libgmp-devel libmpc-devel libmpfr-devel perl(ExtUtils/MakeMaker.pm) perl(Math/BigInt.pm) perl(Math/Complex_C.pm) perl(Math/Complex_C/L.pm) perl(Math/GMP.pm) perl(Math/GMPf.pm) perl(Math/GMPq.pm) perl(Math/GMPz.pm) perl(Math/MPFR.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.33
Release: alt1
Summary: perl interface to the MPC (multi precision complex) library.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SI/SISYPHUS/%{module_name}-%{version}.tar.gz
Provides: perl(Math/MPC.pm) = 1.300

%description
A multiple precision complex number module utilising the MPC library.
   Basically, this module simply wraps the 'mpc' complex number functions
   provided by that library.
   Operator overloading is also available.
   The following documentation heavily plagiarises the mpc documentation.

   use warnings;
   use Math::MPC qw(:mpc);
   Rmpc_set_default_prec(500); # Set default precision to 500 bits
   my $mpc1 = Math::MPC->new(12.5, 1125); # 12.5 + 1125*i
   $mpc2 = sqrt($mpc1);
   print "Square root of $mpc1 is $mpc2\n";

   See also the Math::MPC test suite for some (simplistic) examples of
   usage.



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CHANGES
%perl_vendor_archlib/M*
%perl_vendor_autolib/*

%changelog
