# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Test/NoWarnings.pm) perl(Test/Warn.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 1.11
%define module_name Math-RPN
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.11
Release: alt1
Summary: Perl extension for Reverse Polish Math Expression Evaluation
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SZ/SZABGAB/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The rpn function will take a scalar or list of sclars
which contain an RPN expression
as a set of comma delimited values and operators, and return the
result or stack, depending on context.  If the function is called
in an array context, it will return the entire remaining stack.
If it is called in a scalar context, it will return the top item
of the stack.  In a scalar context, if more than one value remains
on the stack, a warning will be sent to STDERR.

In the event of an error, an error message will be sent to STDERR,
and rpn will return undef.

The expression can contain any combination of values and operators.
Any token which is not an operator is assumed to be a value to be
pushed onto the stack.

An explanation of Reverse Polish Notation is beyond the scope of this
document, but it I will describe it briefly as a stack-based way
of writing mathematical expressions.  This has the advantage of
eliminating the need for parenthesis and simplifying parsing for
computers vs. normal algebraic notation at a slight cost in
the ability of humans to easily comprehend the expressions.

This evaluator works by cycling through the expression from left
to right.  As each token is encountered, it is checked against the
list of operators.  If it matches, then a check is performed for
stack underflow.  If the stack has not underflowed, the operation
is performed by removing the required number of operands from the
top of the stack.  The result is then pushed on to the stack.
Operations for which order is significant (-,/,%%,etc.) are
processed such that the top item on the stack is treated as
the right operand, and the next item down is treated as the
left operand.   Thus, "5,3,-" would yield 2, not -2.  If the
token does not match any of the known operators, the token
is blindly pushed onto the stack.  As a result, one can produce
unexpected results.  For example, the expression "5,3,grandma,+,*"
would produce 15 because 5*(3+0) is how it would end up
evaluated.  That is, 5 would be pushed onto the stack, then
3, then "grandma".  Next, + is evaluated, so 3+"grandma"
is evaluated.  Perl evaluates "grandma" to be numerically 0,
so 3 is pushed back onto the stack.  Next, the * multiplies
the top two items of the stack [5][3], producing 15, which
is pushed back onto the stack.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
