Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Math/Random/MT.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Math-Random-MT-Auto
Version:        6.23
Release:        alt8_18
Summary:        Auto-seeded Mersenne Twister PRNGs
License:        BSD-3-Clause
URL:            https://metacpan.org/release/Math-Random-MT-Auto
Source0:        https://cpan.metacpan.org/modules/by-module/Math/Math-Random-MT-Auto-%{version}.tar.gz
# Build:
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
# Config_m not used
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Exception/Class.pm)
BuildRequires:  perl(Fcntl.pm)
BuildRequires:  perl(Object/InsideOut.pm)
BuildRequires:  perl(Object/InsideOut/Util.pm)
BuildRequires:  perl(Scalar/Util.pm)
# Win32 not used
# Win32::API not used
BuildRequires:  perl(XSLoader.pm)
# Optional run-time:
BuildRequires:  perl(LWP/UserAgent.pm)
# Tests only:
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(threads.pm)
BuildRequires:  perl(threads/shared.pm)
# Dependencies
Requires:       perl(Exception/Class.pm) >= 1.320
Requires:       perl(Fcntl.pm)
Requires:       perl(Object/InsideOut.pm) >= 3.880
Requires:       perl(Scalar/Util.pm) >= 1.230
# LWP::UserAgent used for option of acquiring seed data from Internet sources
Requires:     perl(LWP/UserAgent.pm)
Provides:       bundled(mt19937ar)


# Removed under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(Exception.Class\|Object.InsideOut\|Scalar.Util\).pm)/d

%description
The Mersenne Twister is a fast pseudo-random number generator (PRNG) that is
capable of providing large volumes (> 10^6004) of "high quality"
pseudo-random data to applications that may exhaust available "truly" random
data sources or system-provided PRNGs such as rand.

%prep
%setup -q -n Math-Random-MT-Auto-%{version}
chmod -x examples/*

%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="$RPM_OPT_FLAGS"
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -delete
find $RPM_BUILD_ROOT -type f -name '*.bs' -empty -delete
# %{_fixperms} -c $RPM_BUILD_ROOT

%check
make test

%files
%doc Changes README examples
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/Math*

%changelog
