# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/BigInt.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Math-Revhash
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Reverse hash computation library
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Z/ZH/ZHMYLOVE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is intended for fast and lightweight numbers reversible hashing.
Say there are millions of entries inside RDBMS and each entry identified with
sequential primary key.
Sometimes we want to expose this key to users, i.e. in case it is a session ID.
Due to several reasons it could be a good idea to hide from the outer world
that those session IDs are just a generic sequence of integers.
This module will perform fast, lightweight and reversible translation between
simple sequence `1, 2, 3, ...' and something like `3287, 8542, 1337, ...'
without need for hash-table lookups, large memory storage and any other
expensive mechanisms.

So far, this module is only capable of translating positive non-zero integers.
To use the module you can either choose one of hash lengths: 1..9,
for which all other parameters are pre-defined, or specify any positive
`$length' with non-default `$A' parameter (see below).
In any case `$number' for hashing should not exceed predefined hash length.
`$B' and `$C' parameters could also be specified to avoid extra modular
inverse and power calculation, respectively.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/M*

%changelog
