# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(experimental.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Math-Sequence-DeBruijn
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2022021301
Release: alt1
Summary: Abstract
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AB/ABIGAIL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a single subroutine, `debruijn', which returns
a De Bruijn sequence
for the given alphabet *A* and size *n*. A De Bruijn sequence of an
alphabet *A* and size *n* is a *cyclic* sequence where every substring
of length *n* over the alphabet *A* appears exactly once in the sequence.

For instance, if *A = {0, 1}* and *n = 3*, a possible De Bruijn sequence
would be *00010111*, as each possible substring of length 3
(*000*, *001*, *010*, *011*, *100*, *101*, *110*, and *111*)
appears exactly once. Note that the sequence is cyclic, so *110* can
be found by looking at the last two, and first character of the sequence.

`debruijn' takes two arguments:

=over 2

=item `$alphabet'

Either an arrayref with the symbols to be used in the alphabet, or a
string witht the same. For binary strings, one would use `[0, 1]'
or `"01"'.

=item `$n'

The length of the substrings to consider.

=back

The sequence is returned as a string.

Be aware that the sequence returned has length `k^n', where `k' is
the size of the alphabet. This is the optimal length, so it cannot be
improved, but it does mean both the running time, and memory usage of
the subroutine is exponential in its second argument.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
