# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 1.02
%define module_name Math-VectorReal
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: Module to handle 3D Vector Mathematics
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AN/ANTHONY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The `Math::VectorReal' package defines a 3D mathematical "vector", in a way
that is compatible with the previous CPAN module `Math::MatrixReal'. However
it provides a more vector oriented set of mathematical functions and overload
operators, to the `MatrixReal' package.  For example the normal perl string
functions "x" and "." have been overloaded to allow vector cross and dot
product operations. Vector math formula thus looks like vector math formula in
perl programs using this package.

While this package is compatible with Math::MatrixReal, you DO NOT need to
have that package to perform purely vector orientated calculations. You will
need it however if you wish to do matrix operations with these vectors. The
interface has been designed with this package flexibility in mind.

The vectors are defined in the same way as a "row" `Math::MatrixReal' matrix,
instead of that packages choice of "column" definition for vector operations.
Such vectors are multiplied to matices with the vector on the left and the
matrix on the right. EG:   v * M -> 'v

Not only is this the way I prefer to handle vectors, but it is the way most
graphics books use vectors. As a bonus it results in no overload conflicts
between this package and that of Math::MatrixReal, (the left objects overload
operator is called to do the mathematics). It also is a lot simpler than
`MatrixReal' column vector methods, which were designed for equation solving
rather than 3D geometry operations.

The  vector_matrix()  function provided, simplifies the creation a
`MatrixReal' object from 3 (usually orthogonal) vectors. This with its vector
orientated math operators makes it very easy to define orthogonal rotation
matrices from `Math::VectorReal' objects.  See a rough example in the
synopsis above, or in the file "matrix_test" in the packages source.

NOTE: the 6th element the `Math::MatrixReal' array object is used to hold the
length of the vector so that it can be re-used without needing to be
re-calculated all the time. This means the expensive sqrt() function, need not
be called unless nessary.  This usage should not effect the direct use of
these objects in the `Math::MatrixReal' functions.


%prep
%setup -n %module_name-%module_version
rm matrix_test.pl synopsis.pl

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
