%define module_name Measure-Everything
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Fcntl.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(InfluxDB/LineProtocol.pm) perl(Module/Build.pm) perl(Module/Runtime.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.003
Release: alt1
Summary: Log::Any for Stats
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DO/DOMM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Measure::Everything' tries to provide a standard measuring API for
modules (like Log::Any does for
logging). `Measure::Everything::Adapter's allow applications to
choose the mechanism for measuring stats (for example
`InfluxDB|https://influxdb.com', <OpenTSDB|http://opentsdb.net/>,
Graphite, etc).

For now, `Measure::Everything' only supports `InfluxDB', because
that's what we're using. But I hope that other time series databases
(or other storage backends) can be added to `Measure::Everything'.
Unfortunately, measuring stats is not such a well-established domain
like logging (where we have a set of common log levels, and basically
"just" need to pass some string to some logging sink). So it is very
likely that `Measure::Everything' cannot provide a generic API, where
you can switch out Adapters without changing the measuring code. But
we can try!

`Measure::Everything' currently provides a way to access a global
object `$stats', on which you can call the `write' method. The
currently active `Adapter' decides what to do with the data passed to
`write'. In contrast to `Log::Any', there can be only one active
`Adapter'.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE example
%perl_vendor_privlib/M*

%changelog
