# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Metabase-Fact
%define upstream_version 0.025

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Class for Metabase resources
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Metabase/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(CPAN/DistnameInfo.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(Cwd.pm)
BuildRequires: perl(Data/GUID.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(IO/Prompt/Tiny.pm)
BuildRequires: perl(JSON/MaybeXS.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(Test/Fatal.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(lib.pm)
BuildRequires: perl(overload.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
the Metabase manpage is a framework for associating content and metadata
with arbitrary resources. A Metabase can be used to store test reports,
reviews, coverage analysis reports, reports on static analysis of coding
style, or anything else for which datatypes are constructed.

Metabase::Fact is a base class for Facts (really opinions or analyses) that
can be sent to or retrieved from a Metabase repository.

Structure of a Fact object
    A Fact object associates a 'content' attribute with a 'resource'
    attribute and a 'creator' attribute.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*
/usr/bin/metabase-profile
%{_mandir}/man1/metabase-profile.1*

%changelog
