# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name Method-Alias
%define upstream_version 1.03

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_8
License:    GPL or Artistic
Group:      Development/Perl
Summary:    Create method aliases (and do it safely)
Source:     https://cpan.metacpan.org/modules/by-module/Method/%{upstream_name}-%{upstream_version}.tar.gz
Url:        https://metacpan.org/release/%{upstream_name}
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(Test/More.pm)
BuildArch: noarch
Source44: import.info


%description
For a very long time, whenever I wanted to have a method alias (provide an
alternate name for a method) I would simple do a GLOB alias. That is,

  \# My method
  sub foo {
      ...
  }
  
  \# Alias the method
  *bar = *foo;

While this works fine for functions, it does *not* work for methods.

%prep
%setup -q -n %{upstream_name}-%{upstream_version} 

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
make test

%install
%makeinstall_std

%files
%doc Changes LICENSE README
%{perl_vendor_privlib}/Method


%changelog
