%define module_name Method-Signatures-PP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Babble.pm) perl(ExtUtils/MakeMaker.pm) perl(Import/Into.pm) perl(Moo.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.000005
Release: alt1
Summary: EXPERIMENTAL pure perl method keyword
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MS/MSTROUT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
It's ... a method keyword.

    method foo { ... }

is equivalent to

    sub foo { my $self = shift; ... }

and

    method bar ($arg) { ... }

is equivalent to

    method bar ($arg) { my $self = shift; my ($arg) = @_; ... }

In fact, it isn't just equivalent, this module literally rewrites the source
code in the way shown in the examples above. It does so by using a source
filter (boo, hiss, yes I know) to slurp the entire file, then Damian's
wonderfully insane the PPR manpage module to parse the code to find the keywords, and
then rewrites the source before returning the file to perl to compile.

The wonderful part of this is that it's 100%% pure perl and therefore unlike
every other method implementation is amenable to the App::FatPacker manpage use. The
terrible part of this is that if the parse phase doesn't work, the code has
no idea at all what it's doing and ends up not touching the source code at
all, at which point the compilation failures from the keyword rewriting not
having happened will almost certainly hide the actual problem.

So, for the moment, you are strongly advised to not use this module while
developing code, and instead use the Function::Parameters manpage if you have a not
completely ancient perl and the Method::Signatures::Simple manpage if you're still
back in the stone age banging rocks together, and to then switch your 'use'
line to this module for fatpacking/shipping/etc. - I may yet come up with
a better solution to this and/or beg Damian for help doing so, but at the
time of writing I can offer no guarantees.

Note that the PPR manpage requires perl 5.10 and as such so does this module. However,
if you need to support older perls, you can

    use Method::Signatures::PP::Compile;

which uses ingy's the Module::Compile manpage to generate a .pmc file that should run
fine on whatever version of perl the rest of your code requires. This will
likely be rewritten to use a slightly less lunatic compilation mechanism in
later releases.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
