%define module_name Method-Signatures-Simple-ParseKeyword
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Parse/Keyword.pm) perl(Sub/Name.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.14
Release: alt1
Summary: Basic method declarations with signatures, without source filters
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RH/RHESA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
# -- a basic class -- #
    package User;
    use Method::Signatures::Simple::ParseKeyword;

    method new ($class: $name, $email) {
        my $user = {
            id    => new_id(42),
            name  => $name,
            email => $email,
        };
        bless $user, $class;
    }

    func new_id ($seed) {
        state $id = $seed;
        $id++;
    }

    method name  { $self->{name};  }
    method email { $self->{email}; }
    1;


    # -- other features -- #
    # attributes
    method foo : Bent { $self->{foo} }

    # specify defaults
    method answer ($everything = 42) { "the answer to everything is $everything" }

    # change invocant name
    use Method::Signatures::Simple::ParseKeyword invocant => '$this';
    method foo ($bar) { $this->bar($bar) }
    method bar ($class: $bar) { $class->baz($bar) }

    # use a different function keyword
    use Method::Signatures::Simple::ParseKeyword function_keyword => 'fun';
    fun triple ($num) { 3 * $num }

    # use a different method keyword
    use Method::Signatures::Simple::ParseKeyword method_keyword => 'action';
    action foo { $self->bar }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/M*

%changelog
