%define module_name Module-Build-Database
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Copy/Recursive.pm) perl(File/ShareDir.pm) perl(File/Which.pm) perl(IO/Socket/INET.pm) perl(List/MoreUtils.pm) perl(Module/Build.pm) perl(Path/Class.pm) perl(Sub/Exporter.pm) perl(Test/More.pm) perl(blib.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.58
Release: alt1
Summary: Manage database patches in the style of Module::Build.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BD/BDUGGAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a subclass of Module::Build for modules which depend on a database,
which adds functionality for testing and distributing changes to the database.

Changes are represented as sql files ("patches") which will be fed into a
command line client for the database.

A complete schema is regenerated whenever dbdist is run.

A list of the patches which have been applied is stored in two places :

=over

=item 1.

the file `db/dist/patches_applied.txt'

=item 2.

the table `patches_applied' within the target database.

=back

When the dbinstall action is invoked, any patches in (1) but
not in (2) are applied.  In order to determine whether they will apply
successfully, dbfakeinstall may be run, which does the following :

=over

=item 1.

Dumps the schema for an existing instance.

=item 2.

Applies any patches not found in the `patches_applied' table.

=item 3.

Dumps the resulting schema and compares it to the schema in `db/dist/base.sql'.

=back

If the comparison in step 3 is the same, then one may conclude that applying
the missing patches will produce the desired schema.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes ignore.txt
%perl_vendor_privlib/M*
%perl_vendor_privlib/T*

%changelog
