Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Module-Extract
Version:        0.01
Release:        alt2_44
Summary:        Base class for working with Perl distributions
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Module-Extract
Source0:        https://cpan.metacpan.org/authors/id/A/AD/ADAMK/Module-Extract-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  sed
# Run-time
BuildRequires:  perl(Archive/Extract.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(vars.pm)
# Tests
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Archive/Extract.pm) >= 0.120
Source44: import.info

%description
Module::Extract is a convenience base class for creating module that work
with Perl distributions.

%prep
%setup -q -n Module-Extract-%{version}

# Remove bundled libraries
rm -r inc
sed -i -e '/^inc\// d' MANIFEST
find -type f -exec chmod -x {} +

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
