Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Module-Inspector
Version:        1.05
Release:        alt2_45
Summary:        Integrated API for inspecting Perl distributions
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Module-Inspector
Source0:        https://cpan.metacpan.org/authors/id/A/AD/ADAMK/Module-Inspector-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  sed
# Run-time
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(File/Find/Rule.pm)
BuildRequires:  perl(File/Find/Rule/Perl.pm)
BuildRequires:  perl(File/Find/Rule/VCS.pm)
BuildRequires:  perl(Module/Extract.pm)
BuildRequires:  perl(Module/Manifest.pm)
BuildRequires:  perl(Module/Math/Depends.pm)
BuildRequires:  perl(Params/Util.pm)
BuildRequires:  perl(PPI.pm)
BuildRequires:  perl(PPI/Document/File.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(version.pm)
BuildRequires:  perl(YAML/Tiny.pm)
# Tests
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(PPI/Document/File.pm)
Source44: import.info


%description
An entire ecosystem of CPAN modules exist around the files and formats
relating to the CPAN itself. Parsers and object models for various
different types of files have been created over the years by various people
for various projects.

%prep
%setup -q -n Module-Inspector-%{version}

# Remove bundled libraries
rm -r inc
sed -i -e '/^inc\// d' MANIFEST
find -type f -exec chmod -x {} +

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
