%define module_name Module-List-More
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Slurper.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(String/Wildcard/Bash.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004011
Release: alt1
Summary: Module::List, with more options
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Module-List-More

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is like the Module::List manpage, except for the following differences:

=over

=item * lower startup overhead (with some caveats)

It avoids using the Exporter manpage and implements its own import(). It avoids
the IO::Dir manpage, the Carp manpage, the File::Spec manpage, with the goal of saving a few milliseconds
(a casual test on my PC results in 11ms vs 39ms).

Path separator is hard-coded as `/'.

=item * Recognize `all' option

If set to true and `return_path' is also set to true, will return all found
paths for each module instead of just the first found one. The values of result
will be an arrayref containing all found paths.

=item * Recognize `return_library_path' option

If set to true, will return a `library_path' result key, which is the
associated @INC entry that produces the result.

=item * Recognize `return_version' option

If set to true, will parse module source file with the ExtUtils::MakeMaker manpage's
`parse_version' and return the result in `module_version' key. If version
cannot be detected, a proper undefined value `undef' (instead of the string
`'undef'') is returned.

=item * Recognize `wildcard' option

This boolean option can be set to true to recognize wildcard pattern in prefix.
Wildcard patterns such as jokers (`?', `*', `**'), classes (`[a-z]'), as
well as braces (`{One,Two}') are supported. `**' implies recursive listing.

Examples:

 list_modules("Module::P*", {wildcard=>1, list_modules=>1});

results in something like:

 {
     "Module::Patch"             => undef,
     "Module::Path"              => undef,
     "Module::Pluggable"         => undef,
 }

while:

 list_modules("Module::P**", {wildcard=>1, list_modules=>1});

results in something like:

 {
     "Module::Patch"             => undef,
     "Module::Path"              => undef,
     "Module::Path::More"        => undef,
     "Module::Pluggable"         => undef,
     "Module::Pluggable::Object" => undef,
 }

while:

 list_modules("Module::**le", {wildcard=>1, list_modules=>1});

results in someth...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/M*

%changelog
