%define module_name Module-List-Tiny
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004003
Release: alt1
Summary: A fork of Module::List that starts faster
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Module-List-Tiny

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a fork of the Module::List manpage. It's exactly like Module::List 0.004,
except with lower startup overhead (see benchmarks in
the Bencher::Scenarios::ListingModules::Startup manpage). To accomplish this, it:

=over

=item * does its own exporting instead of using the Exporter manpage

=item * avoids using the Carp manpage and uses the good old `die'

=item * avoids using the IO::Dir manpage and uses plain `opendir'

The problem is that IO::Dir brings in a bunch of other modules.

=item * avoids using the File::Spec manpage and hard-code path separator as `/'

`/' happens to work everywhere with current platforms anyway.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/M*

%changelog
