%define module_name Module-Release-Select
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(DateTime/Format/Natural.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Regexp/Util.pm) perl(String/Escape.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Notation to select release(s)
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Module-Release-Select

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module lets you select one or more releases via an expression. Some example
expressions:

 # exact version number ('=')
 0.002
 =0.002     # ditto

 # version number range with '>', '>=', '<', '<=', '!='. use '&' to join
 # multiple conditions with "and" logic, use '|' or ',' to join with "or" logic.
 >0.002
 >=0.002
 >=0.002 & <=0.015
 <0.002 | >0.015
 0.001, 0.002, 0.003

 # "latest" and "oldest" can replace version number
 latest
 =latest
 <latest           # all releases except the latest
 != latest         # ditto
 >oldest           # all releases except the oldest

 # +n and -m to refer to n releases after and n releases before
 latest-1       # the release before the latest
 0.002 + 1      # the release after 0.002
 > (oldest+1)   # all releases except the oldest and one after that (oldest+1)

 # select by date, any date supported by DateTime::Format::Natural is supported
 date < {yesterday}      # all releases released 2 days ago
 date > {2 months ago}   # all releases after 2 months ago

 # select by author
 author="PERLANCAR"             # all releases released by PERLANCAR
 author != "PERLANCAR"          # all releases not released by PERLANCAR
 author="PERLANCAR" & > 0.005   # all releases after 0.005 that are released by PERLANCAR

To actually select releases, you provide a list of releases in the form of
version numbers in descending order. If you want to select by date or author,
each release will need to be a hashref containing `date' and `author' keys.
Below is an example of a list of releases for the App::orgadb manpage distribution. This
structure is returned by the App::MetaCPANUtils manpage' `list_metacpan_release':

 my @releases = (
    {
      abstract     => "An opinionated Org addressbook toolset",
      author       => "PERLANCAR",
      date         => "2022-11-04T12:57:07",
      distribution => "App-orgadb",
      first        => "",
      maturity     => "released",
      release      => "App-orgadb-0.015",
      status       => "latest",
      version      => 0.015,
  ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/M*

%changelog
