# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define module_version 0.27
%define module_name Module-ThirdParty
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.27
Release: alt1
Summary: Provide information for 3rd party modules (outside CPAN)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SAPER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Perl modules can be roughly classified in three categories: 

=over 4

=item *

core modules, included with the standard Perl distribution; 

=item *

CPAN modules, available from any CPAN mirror; 

=item *

third-party modules, including modules publicly available on the 
Internet (outside CPAN) and "closed" modules available only through 
commercial licenses. They are therefore the very tip of the iceberg,
the most visible part of the DarkPAN, which is all the Perl code,
public or non-public, used in the world.

=back

The list of core modules is provided by `Module::CoreList' and the 
list of CPAN modules is in the file 
http://www.cpan.org/modules/02packages.details.txt.gz and provided 
by modules like `CPANPLUS', but there was no module that listed 
third-party modules. This module tries to address this need by providing 
such a list. 

Why bother in the first place? Because some CPAN modules 
specify such third-party software. Therefore installing them may not 
be as easy as other CPAN modules because one must first find and 
manually install the prerequisites. The aim of `Module::ThirdParty' 
is to provide basic information to installer shells like `CPANPLUS' 
and to give hints to the user. 

Note that there is also another category of modules regarding 
dependencies problems: the ghost modules. Those are modules no longer 
present on the CPAN, but which still haunt it from old PREREQS. They 
can be found in the BackPAN graveyard, for which the only map is 
`Parse::BACKPAN::Packages'. 

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
