Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(File/Next.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Module-Used
Version:        1.3.0
Release:        alt2_28
Summary:        Find modules loaded by Perl code without running it
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Module-Used
Source0:        https://cpan.metacpan.org/authors/id/E/EL/ELLIOTJS/Module-Used-v%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(utf8.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  sed
# Runtime
BuildRequires:  perl(Const/Fast.pm)
BuildRequires:  perl(Exporter.pm)
# Unused BuildRequires:  perl(File::Next) >= 1.02
BuildRequires:  perl(Module/Path.pm)
BuildRequires:  perl(PPI/Document.pm)
# Tests only
BuildRequires:  perl(Test/Deep.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(version.pm)
Requires:       perl(Exporter.pm) >= 5.570
Requires:       perl(File/Next.pm) >= 1.020
Requires:       perl(Module/Path.pm) >= 0.010
Requires:       perl(PPI/Document.pm) >= 1.205





Source44: import.info
%filter_from_requires /^perl(Exporter.pm)/d
%filter_from_requires /^perl(File.Next.pm)/d
%filter_from_requires /^perl(Module.Path.pm)/d
%filter_from_requires /^perl(PPI.Document.pm)/d

%description
Modules are found statically based upon use and require statements. If use
of the base or parent is found, both that module and the referenced ones
will be returned. If Moose or Moose::Role are found, this will look for
extends and with sugar will be looked for; presently, this will miss
modules listed in parentheses.

%prep
%setup -q -n Module-Used-v%{version}
# Remove /usr/bin/env from shebang
sed -i -e '1 s|#!.*|%(perl -MConfig -e 'print $Config{startperl}')|' \
    bin/modules-used

%build
perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=%{buildroot} create_packlist=0
# %{_fixperms} %{buildroot}/*

%check
./Build test

%files
%doc Changes README
%{perl_vendor_privlib}/*
%{_bindir}/*
%{_mandir}/man1/*

%changelog
