%define module_name Mojo-Base-Tiny
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Role/Tiny.pm) perl(Sub/Util.pm) perl(Test/More.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Minimal base class for !Mojo projects
Group: Development/Perl
License: artistic_2
URL: https://github.com/Tekki/mojo-base-tiny

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TE/TEKKI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojo::Base::Tiny manpage is a simple base class for Perl projects with fluent
interfaces.

It is nothing else than the Mojo::Base manpage in a single file without dependencies
outside the core modules (or to be correct, on Perl 5.20 and older you need
the List::Util manpage 1.41). You can copy it directly to your project in all the
"I can't (or don't want to) install the Mojolicious manpage" cases.

  # Automatically enables "strict", "warnings", "utf8" and Perl 5.10 features
  use Mojo::Base::Tiny -strict;
  use Mojo::Base::Tiny -base;
  use Mojo::Base::Tiny 'SomeBaseClass';
  use Mojo::Base::Tiny -role;

All four forms save a lot of typing. Note that role support depends on
the Role::Tiny manpage (2.000001+).

  # use Mojo::Base::Tiny -strict;
  use strict;
  use warnings;
  use utf8;
  use feature ':5.10';
  use mro;
  use IO::Handle ();

  # use Mojo::Base::Tiny -base;
  use strict;
  use warnings;
  use utf8;
  use feature ':5.10';
  use mro;
  use IO::Handle ();
  push @ISA, 'Mojo::Base::Tiny';
  sub has { Mojo::Base::Tiny::attr(__PACKAGE__, @_) }

  # use Mojo::Base::Tiny 'SomeBaseClass';
  use strict;
  use warnings;
  use utf8;
  use feature ':5.10';
  use mro;
  use IO::Handle ();
  require SomeBaseClass;
  push @ISA, 'SomeBaseClass';
  sub has { Mojo::Base::Tiny::attr(__PACKAGE__, @_) }

  # use Mojo::Base::Tiny -role;
  use strict;
  use warnings;
  use utf8;
  use feature ':5.10';
  use mro;
  use IO::Handle ();
  use Role::Tiny;
  sub has { Mojo::Base::Tiny::attr(__PACKAGE__, @_) }

On Perl 5.20+ you can also use the `-signatures' flag with all four forms and
enable support for subroutine signatures.

  # Also enable signatures
  use Mojo::Base::Tiny -strict, -signatures;
  use Mojo::Base::Tiny -base, -signatures;
  use Mojo::Base::Tiny 'SomeBaseClass', -signatures;
  use Mojo::Base::Tiny -role, -signatures;

This will also disable experimental warnings on versions of Perl where this
feature was still experimental.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/M*

%changelog
