# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Method/Modifiers.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Mojo/DB/Role/ResultsRoles.pm) perl(Mojo/Pg.pm) perl(Mojo/mysql.pm) perl(Mojolicious.pm) perl(Role/Tiny.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Mojo-DB-Connector
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Create and cache DB connections using common connection info
Group: Development/Perl
License: perl
URL: https://github.com/srchulo/Mojo-DB-Connector

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SR/SRCHULO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojo::DB::Connector manpage is a thin wrapper around the Mojo::mysql manpage and the Mojo::Pg manpage that is
useful when you want to connect to different databases using slightly different
connection info. It also allows you to easily connect using different settings in
different environments by using environment variables to connect (see the ATTRIBUTES entry elsewhere in this document).
This can be useful when developing using something like Docker,
which easily allows you to set different environment variables in dev/prod.

the Mojo::DB::Connector manpage is a shell class that just composes the Mojo::DB::Connector::Base manpage:

  with 'Mojo::DB::Connector::Base';

You may use the Mojo::DB::Connector::Base manpage as a starting point for your own DB Connectors,
if needed.

See the Mojo::DB::Connector::Role::Cache manpage for the ability to cache connections.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/M*

%changelog
