%define module_name Mojo-DB-Results-Role-Struct
# BEGIN SourceDeps(oneline):
BuildRequires: perl(File/Spec.pm) perl(Module/Build.pm) perl(Module/Build/Tiny.pm) perl(Module/Metadata.pm) perl(Mojolicious.pm) perl(Role/Tiny.pm) perl(Struct/Dumb.pm) perl(Test/More.pm) perl(Test/Needs.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.1
Release: alt1
Summary: Database query results as structs
Group: Development/Perl
License: artistic_2
URL: https://github.com/Grinnz/Mojo-DB-Results-Role-Struct

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOOK/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This role can be applied to a results object for the Mojo::Pg manpage or similar
database APIs. It provides the section on "struct" and the section on "structs" methods which return
the Struct::Dumb manpage records, providing read-only accessors only for the expected
column names. Note that a column name that is not a valid identifier is
trickier to access in this manner.

  my $row = $results->struct;
  my $col_name = 'foo.bar';
  my $val = $row->$col_name;
  # or
  my $val = $row->${\'foo.bar'};

You can apply the role to a results object using the section on "with_roles" in the Mojo::Base manpage,
or apply it to all results objects created by a database manager using
the Mojo::DB::Role::ResultsRoles manpage as shown in the synopsis.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes CONTRIBUTING.md README
%perl_vendor_privlib/M*

%changelog
