%define module_name Mojo-DOM-Role-Restrict
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Method/Modifiers.pm) perl(ExtUtils/MakeMaker.pm) perl(Mojolicious.pm) perl(Role/Tiny.pm) perl(Test/More.pm) perl(Text/Diff.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Restrict tags and attributes
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LN/LNATION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Mojo::DOM;

_my $html = q|<html><head><script>...</script></head><body><p class="okay" id="allow" onclick="not-allow">Restrict <span class="not-okay">HTMthe span entry elsewhere in this document</p></body></html>|;

_my $spec = {
__script => 0, # remove all script tags
__'*' => { #-oapply to all tags
___'*' => 1, # allow all attributes by default
___'onclick' => 0 # disable onclick attributes
__},
__span => {
___class => 0 # disable class attributes on span's
__}
_};

_#<html><head></head><body><p class="okay" id="allow">Restrict <span>HTMthe span entry elsewhere in this document</p></body></html>
_print Mojo::DOM->with_roles('+Restrict')->new($html, $spec);

_.....

_my $dom = Mojo::DOM->with_roles('+Restrict')->new;

_my $html = q|<html><head><script>...</script></head><body><p class="okay" id="allow" onclick="not-allow">Restrict <span class="not-okay">HTMthe span entry elsewhere in this document</p></body></html>|;

_my $spec = {
__script => 0, # no script tags
__'*' => { # allow all tags
___'*' => 1, # allow all attributes
___onclick => sub { 0 }, # disable onclick attributes
___id => sub { return @_ }, # enable id attributes
___class => sub { # allow only 1 class 'okay'
____my ($attr, $val) = @_;
____my $match = $val =~ m/^okay$/;
____return $match ? ($attr, $val) : 0;
___}
__},
__span => {
___validate_tag => sub { # replace span tags with b tags
____return ('b', $_[1]);
___}
__},
__p => {
___validate_tag => sub {
____$_[1]->{id} = "prefixed-" . $_[1]->{id}; # prefix all p tag IDs
____$_[1]->{'data-unknown'} = 'abc';  # extend all p tags with a data-unknown attribute
____return @_;
___}
__},
_};
_
_$dom->parse($html, $spec);
_
_# <html><head></head><body><p class="okay" data-unknown="abc" id="prefixed-allow">Restrict <b>HTMthe b entry elsewhere in this document</p></body></html>
_$dom->to_string;

_# you can change the spec and then re-render
_$spec = {
__'*' => { # allow all tags
___'*' => '^not', # where any attr value matches the regex
__},
_};

_$dom->restrict_spec($spec);
_
_# <html><head><s...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes ignore.txt
%perl_vendor_privlib/M*

%changelog
