# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/mysql.pm) perl(Digest/SHA.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(FindBin.pm) perl(Mojo/Base.pm) perl(Mojo/Collection.pm) perl(Mojo/IOLoop.pm) perl(Mojo/Loader.pm) perl(Mojo/Util.pm) perl(Mojolicious.pm) perl(Mojolicious/Commands.pm) perl(Mojolicious/Lite.pm) perl(Scalar/Util.pm) perl(Test/Mojo.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name Mojo-MySQL5
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Pure-Perl non-blocking I/O MySQL Connector
Group: Development/Perl
License: artistic_2
URL: https://github.com/harry-bix/mojo-mysql5

Source0: http://cpan.org.ua/authors/id/H/HA/HARRYL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
the Mojo::MySQL5 manpage makes MySQL a lot of fun to use with the
Mojolicious real-time web framework.

Database handles are cached automatically, so they can be reused transparently
to increase performance. And you can handle connection timeouts gracefully by
holding on to them only for short amounts of time.

  use Mojolicious::Lite;
  use Mojo::MySQL5;

  helper mysql =>
    sub { state $mysql = Mojo::MySQL5->new('mysql://sri:s3cret@localhost/db') };

  get '/' => sub {
    my $c  = shift;
    my $db = $c->mysql->db;
    $c->render(json => $db->query('select now() as time')->hash);
  };

  app->start;

Every database connection can only handle one active query at a time, this
includes asynchronous ones. So if you start more than one, they will be put on
a waiting list and performed sequentially. To perform multiple queries
concurrently, you have to use multiple connections.
 
  # Performed sequentially (10 seconds)
  my $db = $mysql->db;
  $db->query('select sleep(5)' => sub {...});
  $db->query('select sleep(5)' => sub {...});
 
  # Performed concurrently (5 seconds)
  $mysql->db->query('select sleep(5)' => sub {...});
  $mysql->db->query('select sleep(5)' => sub {...});
 
All cached database handles will be reset automatically if a new process has
been forked, this allows multiple processes to share the same the Mojo::MySQL5 manpage
object safely.


Note that this whole distribution is EXPERIMENTAL and will change without
warning!
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE README.pod examples
%perl_vendor_privlib/M*

%changelog
