%define module_version 0.502001
%define module_name Mojo-PgX-Cursor
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Mojo/Base.pm) perl(Mojo/IOLoop.pm) perl(Mojo/JSON.pm) perl(Mojo/Pg.pm) perl(Mojo/Util.pm) perl(Mojolicious.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(UUID/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.502001
Release: alt1
Summary: Cursor Extension for Mojo::Pg
Group: Development/Perl
License: perl
URL: https://github.com/nnutter/mojo-pgx-cursor

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NN/NNUTTER/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Mojo::PgX::Cursor is an extension for Mojo::Pg that abstract away the (modest)
complications of using a PostgreSQL cursor so that you can use a familiar
iterable interface.

PostgreSQL cursors are useful because the DBD::Pg driver has a long-standing
limitation that it fetches all results to the client as soon as the statement
is executed.  This makes, for example, iterating over a whole table very
memory-expensive.  To work around the issue DBD::Pg
recommends using a
cursor but
with that comes a few complications:

=over

=item Cursors must be named.

=item Cursors are a resource that should be managed.

=item Cursors require a double loop to iterate through all rows.

=back


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes examples
%perl_vendor_privlib/M*

%changelog
