# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Mojolicious.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Mojo-Promisify
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Convert callback code to promise based code
Group: Development/Perl
License: artistic_2
URL: https://github.com/jhthorsen/mojo-promisify

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JH/JHTHORSEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojo::Promisify manpage is a utility module that can upgrade your legacy callback
based API to a the Mojo::Promise manpage based API.

It might not be the most efficient way to run your code, but it will allow
you to easily add methods that will return promises.

This method only works with methods that passes on `$err' as the first argument
to the callback, like this:

  sub get_stuff_by_id {
    my ($self, $id, $cb) = @_;

    my $err = "Some error";
    my $res = undef;
    Mojo::IOLoop->next_tick(sub { $self->$cb($err, $res) });

    return $self;
  }

It can however pass on as many arguments as it wants after the `$err' and all
will be passed on to the fulfillment callback in the promise. `$err' on the
other hand will cause the promise to be rejected.

Note that this module is currently EXPERIMENTAL, but it will most probably not
change much.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/M*

%changelog
