%define module_version 0.3
%define module_name Mojo-Run
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators perl(Mojo/Base.pm)

Name: perl-%module_name
Version: 0.3
Release: alt1
Summary: asynchronous external command execution for Mojo
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/L/LI/LIKHATSKI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use Mojo::Run;
_use Mojo::Log;

_my $run = Mojo::Run->new;
_$run->max_forks(10);
_$run->log(Mojo::Log->new(
_    level => 'error',
_    path  => 'log/mojo_run.log',
_));

_$run->spawn(
_    cmd => sub {
_        my $pid   = shift;
_        my $param = shift; # {a => 1, b => 2}
_        
_        my $data = {};
_        ... do something
_        return $data;
_    },
_    param => {a => 1, b => 2},
_    exec_timeout => 120, # sec
_    stdout_cb => sub {
_        my ($pid, $chunk) = @_;
_    },
_    stderr_cb => sub {
_        my ($pid, $chunk) = @_;
_    },
_    exit_cb => sub {
_        my $pid = shift;
_        my $res = shift;
_        warn $res->{result}->[0];
_    },
_);
_$run->spawn(
_    cmd => 'ps aux',
_    exit_cb => sub {
_        my $pid = shift;
_        my $res = shift;
_    },
_);
_$run->spawn(
_    cmd => ['perl', '-v'],
_    exit_cb => sub {
_        my $pid = shift;
_        my $res = shift;
_    },
_);

_$run->start;


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/M*

%changelog
