%define module_name Mojo-SNMP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Errno.pm) perl(ExtUtils/MakeMaker.pm) perl(Mojolicious.pm) perl(Net/SNMP.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
Epoch: 2
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: Run SNMP requests with Mojo::IOLoop
Group: Development/Perl
License: artistic_2
URL: https://github.com/jhthorsen/mojo-snmp

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JH/JHTHORSEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
You should use this module if you need to fetch data from many SNMP servers
really fast. The module does its best to not get in your way, but rather
provide a simple API which allow you to extract information from multiple
servers at the same time.

This module use the Net::SNMP manpage and the Mojo::IOLoop manpage to fetch data from hosts
asynchronous. It does this by using a custom dispatcher,
the Mojo::SNMP::Dispatcher manpage, which attach the sockets created by the Net::SNMP manpage
directly into the ioloop reactor.

If you want greater speed, you should check out the Net::SNMP::XS manpage and make sure
the Mojo::Reactor::EV manpage is able to load.

the Mojo::SNMP manpage is supposed to be a replacement for a module I wrote earlier,
called the SNMP::Effective manpage. Reason for the rewrite is that I'm using the
framework the Mojolicious manpage which includes an awesome IO loop which allow me to
do cool stuff inside my web server.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README README.pod
%perl_vendor_privlib/M*

%changelog
