%define _without_test 1
%define module_name Mojo-UserAgent-Role-Queued
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Method/Modifiers.pm) perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Role/Tiny.pm) perl(Test/Memory/Cycle.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.15
Release: alt1
Summary: A role to process non-blocking requests in a rate-limiting queue.
Group: Development/Perl
License: perl
URL: https://github.com/dotandimet/Mojo-UserAgent-Role-Queued

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DO/DOTAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Mojo::UserAgent::Role::Queued manages all non-blocking requests made through the Mojo::UserAgent manpage in a queue to limit the number of simultaneous requests.

THIS IS AN INITIAL RELEASE.

the Mojo::UserAgent manpage can make multiple concurrent non-blocking HTTP requests using Mojo's event loop, but because there is only a single process handling all of them, you must take care to limit the number of simultaneous requests you make.

Some discussion of this issue is available here
http://blogs.perl.org/users/stas/2013/01/web-scraping-with-modern-perl-part-1.html
and in Joel Berger's answer here:
http://stackoverflow.com/questions/15152633/perl-mojo-and-json-for-simultaneous-requests.

the Mojo::UserAgent::Role::Queued manpage tries to generalize the practice of managing a large number of requests using a queue, by embedding the queue inside the Mojo::UserAgent manpage itself.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE examples
%perl_vendor_privlib/M*

%changelog
