%define module_name Mojo-UserAgent-Role-Resume
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Method/Modifiers.pm) perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Role/Tiny.pm) perl(Scalar/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.0
Release: alt1
Summary: Role for Mojo::UserAgent that provides resuming capability during downloads
Group: Development/Perl
License: perl
URL: https://gitlab.com/karjala/mojo-useragent-role-resume-for-perl

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KA/KARJALA/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Mojo::UserAgent::Role::Resume is a role for Mojo::UserAgent that allows the user-agent to
retry a URL upon failure.

Retries are made after a connection error or after a server error (HTTP error 5xx) occurs.

It will intelligently determine whether the server it's downloading from properly supports ranged requests,
and if it doesn't, then upon failure it will stop asking for a resume and request the complete file again
from scratch.

It will request the original user-provided URL in its next attempts, not the one that may have resulted from
redirections of the first attempt.

The $tx object returned is the last HTTP transaction that took place.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/M*

%changelog
