# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name MojoX-Date-Local
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Mojo::Date, but in my timezone and with custom formats
Group: Development/Perl
License: perl
URL: https://github.com/brianwisti/MojoX-Date-Local

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BW/BWISTI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module lets you use the Mojo::Date manpage's concise date / time functionality within the context of your own time zone.
That's mainly useful when logging to the console with a custom the Mojo::Log manpage format:

  use Mojo::Log;
  use MojoX::Date::Local;

  my $logger = Mojo::Log->new;

  $logger->format(
    sub ($time, $level, @lines) {
      my ($time, $level, @lines) = @_;
      my $timestamp = MojoX::Date::Local->new($time)->to_datetime;
      my $prefix    = "[$timestamp] [$level]";
      my $message   = join "\n", @lines, "";
      return "$prefix $message";
    }
  );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/M*

%changelog
