# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/JWT.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Mojolicious.pm) perl(Readonly.pm) perl(Syntax/Keyword/Try.pm) perl(Test/More.pm) perl(Test2/Suite.pm) perl(XS/Parse/Keyword.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define module_name Mojolicious-Plugin-Authentication-OIDC
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: OpenID Connect implementation integrated into Mojolicious
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TY/TYRRMINAL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Mojolicious plugin for OpenID Connect
authentication. Designed to work with an OpenID Connect provider like Keycloak,
in confidential access mode. Its design goal is to be configured "all at once"
and then little-to-no effort should be needed to support it elsewhere -- this is 
largely achieved via hooks (the on_success entry elsewhere in this document, the on_error entry elsewhere in this document, the on_login entry elsewhere in this document, 
the on_activity entry elsewhere in this document) and handlers (the get_token entry elsewhere in this document, the get_user entry elsewhere in this document, the get_roles entry elsewhere in this document)

Controller actions `OpenIDConnect#redirect' and `OpenIDConnect#login' are
registered, and can be mapped to routes implicitly (see the make_routes entry elsewhere in this document) or 
manually routed to (e.g., via the Mojolicious::Plugin::OpenAPI manpage).

For the auth workflow, clients should be sent to `OpenIDConnect#redirect' (via 
the redirect_path entry elsewhere in this document if the make_routes entry elsewhere in this document is enabled). Once the client authenticates
to the identity server, they'll be sent to `OpenIDConnect#login' (via 
the login_path entry elsewhere in this document, again, if the make_routes entry elsewhere in this document is enabled). Upon successful login, the
the on_login entry elsewhere in this document hook will be called, followed by the the on_success entry elsewhere in this document hook, which
should send the client to a post-login page. Then, on every server access 
on/after login, the the on_activity entry elsewhere in this document hook will be called.

Controllers may get information about the logged in user via the 
the current_user entry elsewhere in this document and the current_user_roles entry elsewhere in this document helper methods.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes README
%perl_vendor_privlib/M*

%changelog
