# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/Eksblowfish/Bcrypt.pm) perl(Crypt/URandom.pm) perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define module_name Mojolicious-Plugin-BcryptSecure
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Securely bcrypt and validate your passwords.
Group: Development/Perl
License: perl
URL: https://github.com/srchulo/Mojolicious-Plugin-BcryptSecure

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SR/SRCHULO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojolicious::Plugin::BcryptSecure manpage is a fork of the Mojolicious::Plugin::Bcrypt manpage with two main differences:

=over

=item

the Crypt::URandom manpage is used to generate the salt used in the bcrypt entry elsewhere in this document with strongest available source of non-blocking randomness on the current platform.

=item

the secure_compare entry in the Mojo::Util manpage is used in the bcrypt_validate entry elsewhere in this document when comparing the crypted passwords to
help prevent timing attacks.

=back

You also may want to look at the Mojolicious::Command::bcrypt manpage to help easily generate crypted passwords
with your app's `bcrypt' settings via a the Mojolicious::Command manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/M*

%changelog
