%define module_name Mojolicious-Plugin-CanonicalURL
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Scalar/Util.pm) perl(Sub/Quote.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Warn.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Ensures canonical URLs via redirection
Group: Development/Perl
License: perl
URL: https://github.com/srchulo/Mojolicious-Plugin-CanonicalURL

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SR/SRCHULO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojolicious::Plugin::CanonicalURL manpage is a flexible and fast
the Mojlicious::Plugin manpage to give you control over canonicalizing your URLs.
the Mojolicious::Plugin::CanonicalURL manpage uses the Sub::Quote manpage to build the subroutine
used as an the around_action entry in the Mojolicious manpage hook based on the the OPTIONS entry elsewhere in this document you pass
in to make it as fast as possible. the Mojolicious::Plugin::CanonicalURL manpage by
default redirects URLs ending with a slash in their path to their non-slash
equivalent. All redirected URLs will have a status code of
301.

the end_with_slash entry elsewhere in this document can be set to `1' to instead require that canonicalized
URLs end with a slash.

the should_canonicalize_request entry elsewhere in this document and/or the should_not_canonicalize_request entry elsewhere in this document can be set to
override the default that all URLs will be canonicalized.

When redirecting to the canonicalized path, all other attributes of the
the Mojo::URL manpage for the request will remain the same (such as query parameters);
only the path entry in the Mojo::URL manpage will change to the canonicalized form.

the Mojolicious::Plugin::CanonicalURL manpage will remove multiple trailing slashes and
replace them with one slash if the end_with_slash entry elsewhere in this document is a `true' value, or no slashes if
the end_with_slash entry elsewhere in this document is a `false' value.

By default, the Mojolicious::Plugin::CanonicalURL manpage only works for dynamic actions that have
methods that are called. This means that, by default, this plugin will not work for the Mojolicious::Lite manpage routes like this:

  get '/' => {text => 'I .'a Mojolicious!'};

Or routes in a full app like this:

  sub startup {
    my ($self) = @_;

    my $routes = $self->routes;
    $routes->get('/' => {text => 'I .'a Mojolicious!'});
  }

See the canonicalize_before_render entry elsewhere in this document to canonicalize non-dynamic actions.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/M*

%changelog
