%define module_version 0.03
%define module_name Mojolicious-Plugin-FormValidatorLazy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Mojo/Base.pm) perl(Mojo/JSON.pm) perl(Mojo/Parameters.pm) perl(Mojo/Util.pm) perl(Mojolicious.pm) perl(Mojolicious/Lite.pm) perl(Scalar/Util.pm) perl(Test/Mojo.pm) perl(Test/More.pm) perl(Test/UseAllModules.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: FormValidatorLazy
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JA/JAMADAM/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This software is considered to be alpha quality and isn't recommended for
regular usage.

Mojolicious::Plugin::FormValidatorLazy is a Mojolicious plugin for validating
post data with auto-generated validation rules out of original forms.
It analizes the HTML forms before sending them to client, generate the schema,
inject it into original forms within a hidden fields so the plugin can detect
the schema when a post request comes.

The plugin detects following error for now.

=over

=item Unknown form fields.

The form fields represented by name attribute are all white listed and post data
injected unknown fields are blocked.

=item Unknown values of selectable fields.

Selectable values of checkboxes, radio buttons and select options are white
listed and unknow values are blocked.

The plugin also detects characteristics of tag types. Such as unchecked
checkboxes don't appear to data(not required), radio buttons can't be null only
when default value is offered(not null), and so on.

=item Hidden field tamperings.

Hidden typed input can't be ommited(required) and the value takes only one
option. the plugin blocks values against the schema.

=item Values against maxlength attributes.

Values violating of maxlength are blocked.

=item HTML5 validation attributes

HTML5 supports some validation attributes such as [required], [pattern=*],
[type=number], [min=*], [max=*]. The plugin detects them and block violations.

=item CSRF

This also detects CSRF.

=back
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install
rm %buildroot%perl_vendor_privlib/.DS_Store

%files
%doc README.pod Changes
%perl_vendor_privlib/H*
%perl_vendor_privlib/M*

%changelog
