%define module_name Mojolicious-Plugin-Gzip
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Plugin to Gzip Mojolicious responses
Group: Development/Perl
License: perl
URL: https://github.com/srchulo/Mojolicious-Plugin-Gzip

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SR/SRCHULO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojolicious::Plugin::Gzip manpage gzips all responses equal to or greater than a the min_size entry elsewhere in this document by using the the after_dispatch entry in the Mojolicious manpage hook.
the Mojolicious::Plugin::Gzip manpage will only gzip a response if all of these conditions are met:

=over 4

=item *

The the accept_encoding entry in the Mojo::Headers manpage header contains 'gzip'.

=item *

The the body_size entry in the Mojo::Content manpage of the response is greater than or equal to the min_size entry elsewhere in this document.

=item *

The the code entry in the Mojo::Message::Response manpage is 200.

=item *

The the content_encoding entry in the Mojo::Headers manpage for the response is not set.

=back

the Mojolicious::Plugin::Gzip manpage will do these things if those conditions are met:

=over 4

=item *

Set the body entry in the Mojo::Message manpage to the gzipped version of the previous the body entry in the Mojo::Message manpage.

=item *

Set the body_size entry in the Mojo::Message manpage to the size of the gzipped content.

=item *

Set the content_encoding entry in the Mojo::Headers manpage to "gzip".

=item *

If the etag entry in the Mojo::Headers manpage was set, append "-gzip" to the existing the etag entry in the Mojo::Headers manpage. This is done according to RFC-7232, which
states that ETags should be content-coding aware.

=item *

Use the append entry in the Mojo::Headers manpage to append "Accept-Encoding" to the the vary entry in the Mojo::Headers manpage header.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/M*

%changelog
