# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Mojo/Base.pm) perl(Mojo/Exception.pm) perl(Mojo/JWT.pm) perl(Mojo/UserAgent.pm) perl(Mojolicious.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/CPAN/Changes.pm) perl(Test/DistManifest.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Mojolicious-Plugin-Kinde
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.2
Release: alt1
Summary: A Mojo helper and route condition to extract Kinde auth header, verify JWT token, and return the cl...
Group: Development/Perl
License: perl
URL: https://github.com/cngarrison/Mojolicious-Plugin-Kinde

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CN/CNG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Mojolicious::Plugin::Kinde creates a helper method and a route condition. Both retrieve the JWT 
token from the `Authorization' header, verify the JWT, and do some sanity checks on the claims. 
The `get_kinde_claims' helper will return the claims extracted from the token.

The sanity checks include:

=over 4

=item confirm `iss' claim matches the value from `kinde' config

=item confirm the `alg' is `RS256'

=item confirm the `aud' array contains the value from `kinde' config (if not empty)

=back 

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/M*

%changelog
