%define module_name Mojolicious-Plugin-OAuth2-Server
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(FindBin.pm) perl(Mojo/JWT.pm) perl(Mojolicious.pm) perl(Net/OAuth2/AuthorizationServer.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/Mojo.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.51
Release: alt1
Summary: Easier implementation of an OAuth2 Authorization Server / Resource Server with Mojolicious
Group: Development/Perl
License: perl
URL: https://metacpan.org/module/Mojolicious::Plugin::OAuth2::Server

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LE/LEEJO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin enables you to easily (?) write an OAuth2 Authorization Server (AS)
and OAuth2 Resource Server (RS) using Mojolicious. It implements the required
flows and checks leaving you to add functions that are necessary, for example,
to verify an auth code (AC), access token (AT), etc.

In its simplest form you can call the plugin with just a hashref of known clients
and the code will "just work" - however in doing this you will not be able to
run a multi process persistent OAuth2 AS/RS as the known ACs and ATs will not be
shared between processes and will be lost on a restart.

To use this plugin in a more realistic way you need to at a minimum implement
the following functions and pass them to the plugin:

  login_resource_owner
  confirm_by_resource_owner
  verify_client
  store_auth_code
  verify_auth_code
  store_access_token
  verify_access_token

These will be explained in more detail below, in the REQUIRED FUNCTIONS entry elsewhere in this document, and you
can also see the tests and examples included with this distribution. OAuth2
seems needlessly complicated at first, hopefully this plugin will clarify the
various steps and simplify the implementation.

Note that OAuth2 requires https, so you need to have the optional Mojolicious
dependency required to support it. Run the command below to check if
the IO::Socket::SSL manpage is installed.

  $ mojo version
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes README.pod
%perl_vendor_privlib/M*

%changelog
