%define module_name Mojolicious-Plugin-TrustedProxy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Validate/IP.pm) perl(Devel/Cover.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Mojolicious.pm) perl(Net/CIDR/Lite.pm) perl(Net/IP/Lite.pm) perl(Test/More.pm) perl(lib/relative.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Mojolicious plugin to set the remote address, connection scheme, and more from trusted upstream pro...
Group: Development/Perl
License: mit
URL: https://metacpan.org/pod/Mojolicious::Plugin::TrustedProxy

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KA/KAGE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojolicious::Plugin::TrustedProxy manpage modifies every the Mojolicious manpage request
transaction to override connecting user agent values only when the request comes
from trusted upstream sources. You can specify multiple request headers where
trusted upstream sources define the real user agent IP address or the real
connection scheme, or disable either, and can hide the headers from the rest of
the application if needed.

This plugin provides much of the same functionality as setting
`MOJO_REVERSE_PROXY=1', but with more granular control over what headers to
use and what upstream sources can send them. This is especially useful if your
Mojolicious app is directly exposed to the internet, or if it sits behind
multiple upstream proxies. You should therefore ensure your application does
not enable the default Mojolicious reverse proxy handler when using this plugin.

This plugin supports parsing RFC 7239
compliant `Forwarded' headers, validates all IP addresses, and will
automatically convert RFC-4291 IPv4-to-IPv6 mapped values (useful for when your
Mojolicious listens on both IP versions). Please be aware that `Forwarded'
headers are only partially supported. More information is available in the BUGS entry elsewhere in this document.

Debug logging can be enabled by setting the `MOJO_TRUSTEDPROXY_DEBUG'
environment variable. This plugin also adds a `remote_proxy_address'
attribute into `Mojo::Transaction'. If a remote IP address override header is
matched from a trusted upstream proxy, then `tx->remote_proxy_address'
will be set to the IP address of that proxy.

=over

=item Build status

=for html <a href="https://travis-ci.org/Kage/Mojolicious-Plugin-TrustedProxy">
<img src="https://travis-ci.org/Kage/Mojolicious-Plugin-TrustedProxy.svg?branch=master">
</a>

=item Code coverage

=for html <a href='https://coveralls.io/github/Kage/Mojolicious-Plugin-TrustedProxy?branch=master'>
<img src='https://coveralls.io/repos/github/Kage/Mojolicious-Plugin-TrustedProxy/badge.svg?branch=master'>
</a>

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/M*

%changelog
