%define module_name Mojolicious-Plugin-WriteExcel
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Spreadsheet/WriteExcel/Simple.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.00
Release: alt1
Summary: write Excel spreadsheets from Mojolicious
Group: Development/Perl
License: perl
URL: https://github.com/zakame/mojox-renderer-writeexcel

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Z/ZA/ZAKAME/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojolicious::Plugin::WriteExcel manpage is a plugin for writing Excel
spreadsheets.

This plugin converts the `result' element in the stash to an Excel
spreadsheet.  If the stash also has a `heading' element, the renderer
will also write headings in bold type for the columns in the
spreadsheet.

`heading' is an arrayref, while `result' is an array of arrayrefs.

Optionally, a `settings' parameter can be provided to set additional
attributes in the Excel spreadsheet.  Currently 'column_width' is the
only working attribute.  `settings' is a hashref.  Column widths
could be set by passing the settings to `render':

  get '/colwidth.xls' => sub {
    shift->render(
      handler  => 'xls',
      result   => [['small'], ['medium'], ['large']],
      settings => {column_width => {'A:A' => 10, 'B:B' => 25, 'C:D' => 40}},
    );
  };
  settings => {column_width => {'A:A' => 10, 'B:B' => 25, 'C:D' => 40}}


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/M*

%changelog
