# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(MongoDB/Code.pm) perl(Mongoose.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name MongooseX-JSMethod
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Set a method to run MongoDB-server side.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FC/FCO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
If you want to create a recursive method to sum the value of a element and all its children (running on Mongo Server):

    package Test;
    use Moose;
    with 'Mongoose::Document';
    with 'MongooseX::JSMethod';
    
    has name     => (is => 'rw', isa => 'Str');
    has value    => (is => 'rw', isa => 'Int');
    has children => (is => 'rw', isa => 'Mongoose::Join[Test]', default => sub{Mongoose::Join->new(with_class => __PACKAGE__)});
                                                                                
    jsmethod(sum => << 'EOJS');                                                 
          var sum = this.value + 0;
          this.children.forEach(function(x){                                    
             sum += x.fetch().sum();
          });
          return sum;
    EOJS
    
    42


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
