%define module_name Monit-HTTP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(HTTP/Tiny.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Build.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Usage.pm) perl(Pod/Wordlist.pm) perl(Switch.pm) perl(Test/CPAN/Meta.pm) perl(Test/EOL.pm) perl(Test/Kwalitee.pm) perl(Test/MockModule.pm) perl(Test/More.pm) perl(Test/NoBreakpoints.pm) perl(Test/NoTabs.pm) perl(Test/PAUSE/Permissions.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Portability/Files.pm) perl(Test/Spelling.pm) perl(Test/Trap.pm) perl(XML/Fast.pm) perl(YAML.pm) perl(constant.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: an OOP interface to Monit.
Group: Development/Perl
License: mit
URL: https://github.com/djzort/perl-monit-http-api

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DJ/DJZORT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module exposes an interface to talk with Monit via its HTTP interface.
You can use it to get the status of all the monitored services on that particular
host such as CPU and Memory usage, current PID, parent PID, current running status, 
current monitoring status and so on.
The module can be used also for performing actions like:

=over

=item * Start/Stop/Restart services

=item * Monitor/Unmonitor services

    use Monit::HTTP ':constants';

    my $hd = new Monit::HTTP(
            hostname => '127.0.0.1',
            port     => '2812',
            use_auth => 1,
            username => 'admin', 
            password => 'monit',
            );

    eval {
        my @processes = $hd->get_services(TYPE_PROCESS);
        $hd->command_run($processes[0], ACTION_STOP);
        my $service_status_href = $hd->service_status($processes[0]);
    } or do {
            print $@;
    };


=back

%prep
%setup -q -n %{module_name}-%{version}
# require monit to run
rm -f t/05-*

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE CONTRIBUTORS Changes TODO README
%perl_vendor_privlib/M*

%changelog
