# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer2.pm) perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Module/Loaded.pm) perl(Moose.pm) perl(MooseX/ClassAttribute.pm) perl(Plack/Builder.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/TCP.pm) perl(Try/Tiny.pm) perl(Twiggy/Server.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_version 0.900
%define module_name Monitor-MetricsAPI
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.900
Release: alt1
Summary: Metrics collection and reporting for Perl applications.
Group: Development/Perl
License: perl
URL: https://github.com/jsime/monitor-metricsapi

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JS/JSIME/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Monitor::MetricsAPI provides functionality for the collection of arbitrary
application metrics within any event-driven Perl application, as well as the
reporting of those statistics via a JSON-over-HTTP API for consumption by
external systems monitoring tools.

Using Monitor::MetricsAPI first requires that you create the metrics collector
(and accompanying reporting server), by calling create() and providing it with
an address and port to which it should listen. Additionally, any metrics you
wish the collector to track should be defined.

The example above has created a new collector which will listen to all network
interfaces on port 8000. It has also defined two metrics of type 'counter' and
one metric which will invoke the provided subroutine every time the reporting
server displays the value. Refer to the Monitor::MetricsAPI::Metric manpage for more
details on support metric types and their usage.

As your app runs, it can manipulate metrics by calling various methods via the
collector object:

For applications where passing around the collector object to all of your
functions and libraries is not possible, you may also allow Monitor::MetricsAPI
to maintain the collector as a global for you. This is done automatically for
the first collector object you create (and very few applications will want to
use more than one collector anyway).

Instead of invoking metric methods on a collector object, invoke them as class
methods:
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/M*

%changelog
