%define module_name MooX-AttributeFilter
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Method/Modifiers.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Method/Generate/Accessor.pm) perl(Module/Load.pm) perl(Moo.pm) perl(Moose.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Sub/Quote.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test2/V0.pm) perl(Types/Standard.pm) perl(strict.pm) perl(strictures.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002002
Release: alt1
Summary: Implements 'filter' option for Moo-class attributes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VR/VRURG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The idea behind this extension is to overcome the biggest deficiency of
coercion: its ignorance about the object it is acting for. While triggers are
executed as methods, they don't receive the previous attribute value; and
they're called after the attribute is set.

Filter is a method which is called right before attribute value is about to be
set. It receives one or two arguments of which the first is the new attribute
value; the second is the old value. Number of arguments passed depends on
what stage the filter get called at: one is for the construction, two is when
set by writer.

Note: When an attribute was never set before and a writer is used then the
old value filter argument will be undefined.

It is also worth mentioning that a filter is called *always* upon writing a
value into attribute, including initialization from constructor arguments or
lazy builders. See the the SYNOPSIS entry elsewhere in this document. In both cases the filter gets called with a
single argument.

I.e.:

    package LazyOne {
        use Moo;
        use MooX::AttributeFilter;
        
        has lazyField => (
            is => 'rw',
            lazy => 1,
            default => "value",
            filter => sub {
                my $this = shift;
                say "Arguments: ", scalar(@_);
                return $_[0];
            },
        );
    }
    
    my $obj = LazyOne->new;
    $obj->lazyField;        # Arguments: 1
    $obj->lazyField("foo"); # Arguments: 2
    
    $obj = LazyOne->new( lazyField => "bar" );  # Arguments: 1
    $obj->lazyField( "foobar" );                # Arguments: 2

Filter method must always return a (possibly modified) value.

Filter is called *before* any other attribute handlers. Its return value is
then subject for passing through `isa' and `coerce'.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changelog LICENSE
%perl_vendor_privlib/M*

%changelog
